<?php
require_once 'config.php';
require_once 'auth.php';
require_login();
require_admin();

// Crear / editar usuario
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = $_POST['id'] ?? '';
    $username = trim($_POST['username'] ?? '');
    $password = $_POST['password'] ?? '';
    $role = $_POST['role'] ?? 'operador';
    if ($role !== 'admin') $role = 'operador';

    if ($username !== '') {
        if ($id) {
            if ($password !== '') {
                $hash = password_hash($password, PASSWORD_DEFAULT);
                $stmt = $pdo->prepare("UPDATE users SET username=?, password_hash=?, role=? WHERE id=?");
                $stmt->execute([$username, $hash, $role, $id]);
            } else {
                $stmt = $pdo->prepare("UPDATE users SET username=?, role=? WHERE id=?");
                $stmt->execute([$username, $role, $id]);
            }
        } else {
            if ($password === '') {
                $password = 'prisa123';
            }
            $hash = password_hash($password, PASSWORD_DEFAULT);
            $stmt = $pdo->prepare("INSERT INTO users (username, password_hash, role) VALUES (?, ?, ?)");
            $stmt->execute([$username, $hash, $role]);
        }
    }

    header('Location: users.php');
    exit;
}

// Eliminar usuario (no se puede borrar a sí mismo)
if (isset($_GET['delete'])) {
    $id = (int)$_GET['delete'];
    if ($id !== (int)($_SESSION['user_id'] ?? 0)) {
        $stmt = $pdo->prepare("DELETE FROM users WHERE id=?");
        $stmt->execute([$id]);
    }
    header('Location: users.php');
    exit;
}

// Editar
$editUser = null;
if (isset($_GET['edit'])) {
    $id = (int)$_GET['edit'];
    $stmt = $pdo->prepare("SELECT * FROM users WHERE id=?");
    $stmt->execute([$id]);
    $editUser = $stmt->fetch(PDO::FETCH_ASSOC);
}

$users = $pdo->query("SELECT * FROM users ORDER BY id ASC")->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Usuarios - PRISA DOOH</title>
    <link rel="stylesheet" href="assets/style.css">
</head>
<body class="admin-body">
<?php include 'topbar.php'; ?>
<div class="admin-container">
    <div class="admin-header">
        <div>
            <h1>Usuarios</h1>
            <p>Creá accesos para operadores y administradores.</p>
        </div>
    </div>

    <div class="grid-2">
        <div class="card">
            <h2><?php echo $editUser ? 'Editar usuario' : 'Nuevo usuario'; ?></h2>
            <form method="post" class="form">
                <input type="hidden" name="id" value="<?php echo htmlspecialchars($editUser['id'] ?? ''); ?>">
                <label>Usuario
                    <input type="text" name="username" required placeholder="Ej: operador.mdp" value="<?php echo htmlspecialchars($editUser['username'] ?? ''); ?>">
                </label>
                <label>Contraseña <?php echo $editUser ? '(dejar vacío para no cambiar)' : ''; ?>
                    <input type="password" name="password" <?php echo $editUser ? '' : 'required'; ?>>
                </label>
                <label>Rol
                    <select name="role">
                        <option value="operador" <?php echo (isset($editUser['role']) && $editUser['role']==='operador')?'selected':''; ?>>Operador (solo carga)</option>
                        <option value="admin" <?php echo (isset($editUser['role']) && $editUser['role']==='admin')?'selected':''; ?>>Admin (total)</option>
                    </select>
                </label>
                <button type="submit" class="btn-primary"><?php echo $editUser ? 'Guardar cambios' : 'Crear usuario'; ?></button>
                <?php if (!$editUser): ?>
                    <p class="hint">Si no indicás contraseña, se usará: <strong>prisa123</strong></p>
                <?php endif; ?>
            </form>
        </div>

        <div class="card">
            <h2>Listado de usuarios</h2>
            <table class="table">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Usuario</th>
                        <th>Rol</th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                <?php foreach ($users as $u): ?>
                    <tr>
                        <td>#<?php echo $u['id']; ?></td>
                        <td><?php echo htmlspecialchars($u['username']); ?></td>
                        <td><?php echo htmlspecialchars(strtoupper($u['role'] ?? 'admin')); ?></td>
                        <td class="table-actions">
                            <a href="users.php?edit=<?php echo $u['id']; ?>" class="btn-small">Editar</a>
                            <?php if ($u['id'] != (int)($_SESSION['user_id'] ?? 0)): ?>
                                <a href="users.php?delete=<?php echo $u['id']; ?>" class="btn-small btn-danger" onclick="return confirm('¿Eliminar usuario?');">Eliminar</a>
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
</body>
</html>
