<?php
require_once 'config.php';
require_once 'auth.php';
require_login();

$screenId = isset($_GET['screen_id']) ? (int)$_GET['screen_id'] : 0;
if (!$screenId) {
    header('Location: screens.php');
    exit;
}
$stmt = $pdo->prepare("SELECT * FROM screens WHERE id=?");
$stmt->execute([$screenId]);
$screen = $stmt->fetch(PDO::FETCH_ASSOC);
if (!$screen) {
    header('Location: screens.php');
    exit;
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Monitor - <?php echo htmlspecialchars($screen['name']); ?> - PRISA DOOH</title>
    <link rel="stylesheet" href="assets/style.css">
    <style>
        .monitor-frame-wrap {
            margin-top: 12px;
            border-radius: 16px;
            overflow: hidden;
            border: 1px solid rgba(30,64,175,0.9);
            background: #000;
        }
        .monitor-frame {
            width: 100%;
            aspect-ratio: 16 / 9;
            border: none;
        }
    </style>
</head>
<body class="admin-body">
<?php include 'topbar.php'; ?>
<div class="admin-container">
    <div class="admin-header">
        <div>
            <h1>Monitor en vivo</h1>
            <p>Vista de lo que está saliendo en: <strong><?php echo htmlspecialchars($screen['name']); ?></strong></p>
        </div>
    </div>
    <div class="card">
        <p class="hint">Esta vista replica exactamente el player de la pantalla (ideal para control y screenshots).</p>
        <div class="monitor-frame-wrap">
            <iframe class="monitor-frame" src="player.php?screen_id=<?php echo $screenId; ?>"></iframe>
        </div>
    </div>
</div>
</body>
</html>
