<?php
require_once 'config.php';
require_once 'auth.php';
require_login();

$screenId = isset($_GET['screen_id']) ? (int)$_GET['screen_id'] : 0;

// Cargar pantallas
$screens = $pdo->query("SELECT * FROM screens ORDER BY name ASC")->fetchAll(PDO::FETCH_ASSOC);
if (!$screens) {
    header('Location: screens.php');
    exit;
}

if (!$screenId) {
    $screenId = (int)$screens[0]['id'];
}

// Procesar subida / alta creatividad
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['save_creative'])) {
    $screenId = (int)($_POST['screen_id'] ?? $screenId);
    $duration = (int)($_POST['duration'] ?? 10);
    if ($duration < 3) $duration = 3;

    $advertiser = trim($_POST['advertiser'] ?? '');
    $mode = $_POST['mode'] ?? 'upload'; // upload | url
    $external_url = trim($_POST['external_url'] ?? '');
    $kind = $_POST['kind'] ?? 'image'; // image | video

    $fileName = null;
    $type = $kind === 'video' ? 'video' : 'image';

    if ($mode === 'upload') {
        if (!isset($_FILES['file']) || $_FILES['file']['error'] !== UPLOAD_ERR_OK) {
            die('Error al subir archivo');
        }

        $allowed = ['image/jpeg','image/png','image/gif','video/mp4','video/webm'];
        $fileType = mime_content_type($_FILES['file']['tmp_name']);
        if (!in_array($fileType, $allowed)) {
            die('Formato no permitido');
        }

        $ext = pathinfo($_FILES['file']['name'], PATHINFO_EXTENSION);
        $type = strpos($fileType, 'video') === 0 ? 'video' : 'image';

        $uploadDir = __DIR__ . '/uploads';
        if (!file_exists($uploadDir)) {
            mkdir($uploadDir, 0777, true);
        }

        $fileName = uniqid('creative_') . '.' . $ext;
        $dest = $uploadDir . '/' . $fileName;
        move_uploaded_file($_FILES['file']['tmp_name'], $dest);
        $external_url = null;
    } else {
        // modo URL tipo LatinAd
        if ($external_url === '') {
            die('Debés indicar una URL cuando usás el modo URL.');
        }
        $fileName = null;
    }

    $stmt = $pdo->prepare("SELECT COALESCE(MAX(sort_order),0)+1 FROM media WHERE screen_id=?");
    $stmt->execute([$screenId]);
    $order = (int)$stmt->fetchColumn();

    $stmt = $pdo->prepare("INSERT INTO media (screen_id, file_name, type, duration, sort_order, active, advertiser, external_url) VALUES (?, ?, ?, ?, ?, 1, ?, ?)");
    $stmt->execute([$screenId, $fileName, $type, $duration, $order, $advertiser, $external_url]);

    header('Location: media.php?screen_id=' . $screenId);
    exit;
}

// Eliminar creatividad
if (isset($_GET['delete'])) {
    $id = (int)$_GET['delete'];
    $stmt = $pdo->prepare("SELECT file_name, screen_id FROM media WHERE id=?");
    $stmt->execute([$id]);
    $m = $stmt->fetch(PDO::FETCH_ASSOC);
    if ($m) {
        if (!empty($m['file_name'])) {
            $path = __DIR__ . '/uploads/' . $m['file_name'];
            if (file_exists($path)) unlink($path);
        }
        $pdo->prepare("DELETE FROM media WHERE id=?")->execute([$id]);
        header('Location: media.php?screen_id=' . (int)$m['screen_id']);
        exit;
    }
}

// Actualizar lista (orden, duración, activo)
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['update_list'])) {
    $screenId = (int)($_POST['screen_id'] ?? $screenId);
    $ids = $_POST['id'] ?? [];
    $orders = $_POST['sort_order'] ?? [];
    $durations = $_POST['duration_item'] ?? [];
    $actives = $_POST['active_item'] ?? [];

    foreach ($ids as $idx => $id) {
        $id = (int)$id;
        $order = (int)($orders[$idx] ?? 0);
        $dur = (int)($durations[$idx] ?? 10);
        $active = isset($actives[$idx]) ? 1 : 0;

        $stmt = $pdo->prepare("UPDATE media SET sort_order=?, duration=?, active=?, updated_at=strftime('%s','now') WHERE id=?");
        $stmt->execute([$order, $dur, $active, $id]);
    }

    header('Location: media.php?screen_id=' . $screenId);
    exit;
}

$stmt = $pdo->prepare("SELECT * FROM screens WHERE id=?");
$stmt->execute([$screenId]);
$currentScreen = $stmt->fetch(PDO::FETCH_ASSOC);

$stmt = $pdo->prepare("SELECT * FROM media WHERE screen_id=? ORDER BY sort_order ASC, id ASC");
$stmt->execute([$screenId]);
$media = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Creatividades - PRISA DOOH</title>
    <link rel="stylesheet" href="assets/style.css">
    <script>
    function toggleMode() {
        const modeUpload = document.getElementById('mode_upload').checked;
        const rowFile = document.getElementById('row_file');
        const rowUrl = document.getElementById('row_url');
        if (modeUpload) {
            rowFile.style.display = '';
            rowUrl.style.display = 'none';
        } else {
            rowFile.style.display = 'none';
            rowUrl.style.display = '';
        }
    }
    </script>
</head>
<body class="admin-body" onload="toggleMode()">
<?php include 'topbar.php'; ?>
<div class="admin-container">
    <div class="admin-header">
        <div>
            <h1>Creatividades</h1>
            <p>Subí archivos o cargá URLs tipo LatinAd, con nombre de anunciante.</p>
        </div>
        <form method="get" class="screen-selector">
            <label>Pantalla:
                <select name="screen_id" onchange="this.form.submit()">
                    <?php foreach ($screens as $s): ?>
                        <option value="<?php echo $s['id']; ?>" <?php echo $s['id']==$screenId?'selected':''; ?>>
                            <?php echo htmlspecialchars($s['name']); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </label>
            <a href="monitor.php?screen_id=<?php echo $screenId; ?>" class="btn-secondary" style="margin-left:8px;" target="_blank">Ver pantalla en vivo</a>
        </form>
    </div>

    <div class="grid-2">
        <div class="card">
            <h2>Nueva creatividad para: <span class="badge"><?php echo htmlspecialchars($currentScreen['name']); ?></span></h2>
            <form method="post" enctype="multipart/form-data" class="form">
                <input type="hidden" name="screen_id" value="<?php echo $screenId; ?>">
                <input type="hidden" name="save_creative" value="1">

                <label>Anunciante
                    <input type="text" name="advertiser" placeholder="Ej: Mercado Libre, Adidas, etc.">
                </label>

                <label>Tipo de pieza
                    <select name="kind">
                        <option value="image">Imagen (JPG/PNG/GIF)</option>
                        <option value="video">Video (MP4/WEBM)</option>
                    </select>
                </label>

                <label>Origen
                    <div class="radio-row">
                        <label><input type="radio" name="mode" id="mode_upload" value="upload" checked onclick="toggleMode()"> Archivo subido</label>
                        <label><input type="radio" name="mode" id="mode_url" value="url" onclick="toggleMode()"> URL externa (tipo LatinAd)</label>
                    </div>
                </label>

                <div id="row_file">
                    <label>Archivo (JPG, PNG, GIF, MP4, WEBM)
                        <input type="file" name="file">
                    </label>
                </div>

                <div id="row_url" style="display:none;">
                    <label>URL de la creatividad
                        <input type="text" name="external_url" placeholder="https://... (imagen o video alojado externamente)">
                    </label>
                </div>

                <label>Duración (segundos)
                    <input type="number" name="duration" value="10" min="3" max="120">
                </label>

                <button type="submit" class="btn-primary">Guardar creatividad</button>
                <p class="hint">El player toma los cambios automáticamente en el próximo loop.</p>
            </form>
        </div>

        <div class="card">
            <h2>Playlist actual</h2>
            <?php if (!$media): ?>
                <p>No hay creatividades cargadas para esta pantalla.</p>
            <?php else: ?>
                <form method="post">
                    <input type="hidden" name="screen_id" value="<?php echo $screenId; ?>">
                    <input type="hidden" name="update_list" value="1">
                    <table class="table">
                        <thead>
                            <tr>
                                <th>Orden</th>
                                <th>Preview</th>
                                <th>Tipo</th>
                                <th>Anunciante</th>
                                <th>Origen</th>
                                <th>Duración</th>
                                <th>Activa</th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody>
                        <?php foreach ($media as $idx => $m): ?>
                            <?php
                                $origin = $m['external_url'] ? 'URL' : 'Archivo';
                                $url = $m['external_url'] ?: ('uploads/' . $m['file_name']);
                            ?>
                            <tr>
                                <td>
                                    <input type="hidden" name="id[]" value="<?php echo $m['id']; ?>">
                                    <input type="number" name="sort_order[]" value="<?php echo (int)$m['sort_order']; ?>" style="width:60px;">
                                </td>
                                <td>
                                    <?php if ($m['type']==='image'): ?>
                                        <img src="<?php echo htmlspecialchars($url); ?>" class="thumb">
                                    <?php else: ?>
                                        <video src="<?php echo htmlspecialchars($url); ?>" class="thumb" muted></video>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo strtoupper($m['type']); ?></td>
                                <td><?php echo htmlspecialchars($m['advertiser'] ?? ''); ?></td>
                                <td><?php echo $origin; ?></td>
                                <td>
                                    <input type="number" name="duration_item[]" value="<?php echo (int)$m['duration']; ?>" style="width:60px;">
                                </td>
                                <td class="center">
                                    <input type="checkbox" name="active_item[<?php echo $idx; ?>]" <?php echo $m['active']?'checked':''; ?>>
                                </td>
                                <td>
                                    <a href="media.php?delete=<?php echo $m['id']; ?>" class="btn-small btn-danger" onclick="return confirm('¿Eliminar creatividad?');">Eliminar</a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                        </tbody>
                    </table>
                    <button type="submit" class="btn-primary">Guardar cambios</button>
                </form>
            <?php endif; ?>
        </div>
    </div>
</div>
</body>
</html>
