<?php
require_once 'config.php';
require_once 'auth.php';

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username'] ?? '');
    $password = $_POST['password'] ?? '';

    $stmt = $pdo->prepare("SELECT * FROM users WHERE username = ?");
    $stmt->execute([$username]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($user && password_verify($password, $user['password_hash'])) {
        $_SESSION['user_id'] = $user['id'];
        $_SESSION['username'] = $user['username'];
        $_SESSION['role'] = $user['role'] ?? 'admin';
        header('Location: screens.php');
        exit;
    } else {
        $error = 'Usuario o contraseña incorrectos';
    }
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Login - PRISA DOOH</title>
    <link rel="stylesheet" href="assets/style.css">
</head>
<body class="login-body">
<div class="login-card">
    <div class="login-logo-wrap">
        <img src="assets/logo_prisa.svg" alt="PRISA" class="login-logo-img">
    </div>
    <h1 class="login-title">Panel de Pantallas</h1>
    <p class="login-subtitle">Gestión centralizada de dispositivos DOOH.</p>
    <?php if ($error): ?>
        <div class="alert alert-error"><?php echo htmlspecialchars($error); ?></div>
    <?php endif; ?>
    <form method="post" class="form">
        <label>Usuario
            <input type="text" name="username" required placeholder="admin">
        </label>
        <label>Contraseña
            <input type="password" name="password" required placeholder="admin123">
        </label>
        <button type="submit" class="btn-primary">Ingresar</button>
        <p class="login-hint">Demo: <strong>admin</strong> / <strong>admin123</strong></p>
    </form>
</div>
</body>
</html>
