<?php
// Configuración PRISA DOOH
$dbPath = __DIR__ . '/data/database.sqlite';

if (!file_exists(__DIR__ . '/data')) {
    mkdir(__DIR__ . '/data', 0777, true);
}

try {
    $pdo = new PDO('sqlite:' . $dbPath);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (Exception $e) {
    die('Error al conectar con la base de datos: ' . $e->getMessage());
}

// Tablas base
$pdo->exec("
CREATE TABLE IF NOT EXISTS users (
    id INTEGER PRIMARY KEY AUTOINCREMENT,
    username TEXT UNIQUE NOT NULL,
    password_hash TEXT NOT NULL
);
");

$pdo->exec("
CREATE TABLE IF NOT EXISTS screens (
    id INTEGER PRIMARY KEY AUTOINCREMENT,
    name TEXT NOT NULL,
    location TEXT,
    resolution TEXT,
    active INTEGER DEFAULT 1,
    updated_at INTEGER DEFAULT (strftime('%s','now'))
);
");

$pdo->exec("
CREATE TABLE IF NOT EXISTS media (
    id INTEGER PRIMARY KEY AUTOINCREMENT,
    screen_id INTEGER NOT NULL,
    file_name TEXT,
    type TEXT NOT NULL, -- image | video
    duration INTEGER DEFAULT 10,
    sort_order INTEGER DEFAULT 0,
    active INTEGER DEFAULT 1,
    created_at INTEGER DEFAULT (strftime('%s','now')),
    updated_at INTEGER DEFAULT (strftime('%s','now')),
    FOREIGN KEY (screen_id) REFERENCES screens(id)
);
");

// Migraciones suaves (por si ya existía la base)
function prisa_add_column_if_missing(PDO $pdo, string $table, string $column, string $definition) {
    $stmt = $pdo->prepare("PRAGMA table_info($table)");
    $stmt->execute();
    $columns = $stmt->fetchAll(PDO::FETCH_ASSOC);
    foreach ($columns as $col) {
        if (strcasecmp($col['name'], $column) === 0) {
            return;
        }
    }
    $pdo->exec("ALTER TABLE $table ADD COLUMN $column $definition");
}

// role en usuarios (admin / operador)
prisa_add_column_if_missing($pdo, 'users', 'role', "TEXT NOT NULL DEFAULT 'admin'");

// anunciante, url externa en media
prisa_add_column_if_missing($pdo, 'media', 'advertiser', "TEXT");
prisa_add_column_if_missing($pdo, 'media', 'external_url', "TEXT");

// Usuario admin por defecto
$stmt = $pdo->prepare("SELECT COUNT(*) AS c FROM users");
$stmt->execute();
$count = (int)$stmt->fetchColumn();

if ($count === 0) {
    $username = 'admin';
    $passwordHash = password_hash('admin123', PASSWORD_DEFAULT);
    $role = 'admin';
    $stmt = $pdo->prepare("INSERT INTO users (username, password_hash, role) VALUES (?, ?, ?)");
    $stmt->execute([$username, $passwordHash, $role]);
}
?>
