<?php
require_once 'config.php';

$screenId = isset($_GET['screen_id']) ? (int)$_GET['screen_id'] : 0;
if (!$screenId) {
    die('Falta screen_id en la URL. Ej: player.php?screen_id=1');
}

$stmt = $pdo->prepare("SELECT * FROM screens WHERE id=?");
$stmt->execute([$screenId]);
$screen = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$screen) {
    die('Pantalla no encontrada');
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title><?php echo htmlspecialchars($screen['name']); ?> - Player PRISA</title>
    <link rel="stylesheet" href="assets/style.css">
    <style>
        body {
            margin: 0;
            background: radial-gradient(circle at top, #0b1120 0, #020617 40%, #020617 100%);
            color: #fff;
            font-family: system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", sans-serif;
            overflow: hidden;
        }
    </style>
</head>
<body>
<div id="player-shell">
    <div class="player-overlay">
        <div class="player-brand">
            <img src="assets/logo_prisa.svg" class="player-logo" alt="PRISA">
            <div class="player-brand-text">
                <div class="brand-title">PRISA DOOH</div>
                <div class="brand-subtitle"><?php echo htmlspecialchars($screen['name']); ?></div>
            </div>
        </div>
        <div class="player-status">
            <span id="statusText">Cargando playlist...</span>
        </div>
    </div>
    <div id="playerStage" class="player-stage">
        <!-- Contenido dinámico -->
    </div>
</div>

<script>
const screenId = <?php echo $screenId; ?>;
let playlist = [];
let currentIndex = 0;
let lastUpdate = 0;
let currentTimeout = null;
let isPlayingVideo = false;

async function fetchPlaylist(force = false) {
    try {
        const url = 'api_playlist.php?screen_id=' + screenId + '&since=' + (force ? 0 : lastUpdate);
        const res = await fetch(url + '&_=' + Date.now());
        const data = await res.json();

        if (data.changed) {
            playlist = data.items || [];
            lastUpdate = data.last_update || 0;
            if (!playlist.length) {
                document.getElementById('statusText').textContent = 'Sin creatividades activas.';
            } else {
                document.getElementById('statusText').textContent = 'Playlist activa (' + playlist.length + ' piezas)';
            }
        }
    } catch (e) {
        console.error(e);
        document.getElementById('statusText').textContent = 'Error de conexión con el CMS';
    }
}

function clearStage() {
    const stage = document.getElementById('playerStage');
    stage.innerHTML = '';
}

function playNext() {
    if (!playlist.length) {
        clearStage();
        document.getElementById('statusText').textContent = 'Sin creatividades activas.';
        currentTimeout = setTimeout(playNext, 5000);
        return;
    }

    if (currentIndex >= playlist.length) {
        currentIndex = 0;
    }

    const item = playlist[currentIndex];
    currentIndex++;

    clearStage();
    const stage = document.getElementById('playerStage');

    if (item.type === 'video') {
        const video = document.createElement('video');
        video.src = item.url + '?_=' + Date.now();
        video.autoplay = true;
        video.muted = false;
        video.playsInline = true;
        video.className = 'player-video';
        stage.appendChild(video);
        isPlayingVideo = true;

        let ended = false;
        const next = () => {
            if (ended) return;
            ended = true;
            isPlayingVideo = false;
            currentTimeout = null;
            playNext();
        };

        video.addEventListener('ended', next);
        video.addEventListener('error', next);

        const maxDuration = (item.duration && item.duration > 0 ? item.duration : 30) * 1000;
        currentTimeout = setTimeout(next, maxDuration);

    } else {
        const img = document.createElement('img');
        img.src = item.url + '?_=' + Date.now();
        img.className = 'player-image';
        stage.appendChild(img);
        isPlayingVideo = false;

        const dur = (item.duration && item.duration > 0 ? item.duration : 10) * 1000;
        currentTimeout = setTimeout(() => {
            currentTimeout = null;
            playNext();
        }, dur);
    }
}

async function loop() {
    await fetchPlaylist(false);
    if (!isPlayingVideo && !currentTimeout) {
        playNext();
    }
}

(async () => {
    await fetchPlaylist(true);
    playNext();
    setInterval(loop, 20000);
})();
</script>
</body>
</html>
