<?php
// Configuración básica PRISA
$dbPath = __DIR__ . '/data/database.sqlite';

if (!file_exists(__DIR__ . '/data')) {
    mkdir(__DIR__ . '/data', 0777, true);
}

try {
    $pdo = new PDO('sqlite:' . $dbPath);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (Exception $e) {
    die('Error al conectar con la base de datos: ' . $e->getMessage());
}

// Autocrea tablas si no existen
$pdo->exec("
CREATE TABLE IF NOT EXISTS users (
    id INTEGER PRIMARY KEY AUTOINCREMENT,
    username TEXT UNIQUE NOT NULL,
    password_hash TEXT NOT NULL
);
");

$pdo->exec("
CREATE TABLE IF NOT EXISTS screens (
    id INTEGER PRIMARY KEY AUTOINCREMENT,
    name TEXT NOT NULL,
    location TEXT,
    resolution TEXT,
    active INTEGER DEFAULT 1,
    updated_at INTEGER DEFAULT (strftime('%s','now'))
);
");

$pdo->exec("
CREATE TABLE IF NOT EXISTS media (
    id INTEGER PRIMARY KEY AUTOINCREMENT,
    screen_id INTEGER NOT NULL,
    file_name TEXT NOT NULL,
    type TEXT NOT NULL, -- image | video
    duration INTEGER DEFAULT 10,
    sort_order INTEGER DEFAULT 0,
    active INTEGER DEFAULT 1,
    created_at INTEGER DEFAULT (strftime('%s','now')),
    updated_at INTEGER DEFAULT (strftime('%s','now')),
    FOREIGN KEY (screen_id) REFERENCES screens(id)
);
");

// Crear usuario admin por defecto si no existe
$stmt = $pdo->prepare("SELECT COUNT(*) FROM users");
$stmt->execute();
$count = (int)$stmt->fetchColumn();

if ($count === 0) {
    $username = 'admin';
    $passwordHash = password_hash('admin123', PASSWORD_DEFAULT);
    $stmt = $pdo->prepare("INSERT INTO users (username, password_hash) VALUES (?, ?)");
    $stmt->execute([$username, $passwordHash]);
}
?>
